/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.skinsrestorer.api.bukkit.BukkitHeadAPI;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.shadow.xseries.XMaterial;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.utils.C;
import net.skinsrestorer.shared.utils.log.SRLogger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class SkinsGUI
implements InventoryHolder {
    private final SkinsRestorer plugin;
    private final int page;
    private Inventory inventory;

    public static Inventory createGUI(SkinsRestorer plugin, int page, Map<String, IProperty> skinsList) {
        SkinsGUI instance = new SkinsGUI(plugin, page);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)instance, (int)54, (String)C.c(Locale.SKINSMENU_TITLE_NEW).replace("%page", String.valueOf(page + 1)));
        instance.setInventory(inventory);
        ItemStack none = new GuiGlass(GlassType.NONE).getItemStack();
        ItemStack delete = new GuiGlass(GlassType.DELETE).getItemStack();
        ItemStack prev = new GuiGlass(GlassType.PREV).getItemStack();
        ItemStack next = new GuiGlass(GlassType.NEXT).getItemStack();
        inventory.setItem(36, none);
        inventory.setItem(37, none);
        inventory.setItem(38, none);
        inventory.setItem(39, none);
        inventory.setItem(40, none);
        inventory.setItem(41, none);
        inventory.setItem(42, none);
        inventory.setItem(43, none);
        inventory.setItem(44, none);
        inventory.setItem(45, none);
        inventory.setItem(46, none);
        inventory.setItem(47, none);
        inventory.setItem(48, delete);
        inventory.setItem(49, delete);
        inventory.setItem(50, delete);
        inventory.setItem(53, none);
        inventory.setItem(52, none);
        inventory.setItem(51, none);
        if (page > 0) {
            inventory.setItem(45, prev);
            inventory.setItem(46, prev);
            inventory.setItem(47, prev);
        }
        skinsList.forEach((name, property) -> {
            if (CharBuffer.wrap(name.toCharArray()).chars().anyMatch(i -> Character.isLetter(i) && Character.isUpperCase(i))) {
                plugin.getSrLogger().info("ERROR: skin " + name + ".skin contains a Upper case!");
                plugin.getSrLogger().info("Please rename the file name to a lower case!.");
                return;
            }
            inventory.addItem(new ItemStack[]{SkinsGUI.createSkull(plugin.getSrLogger(), name, property)});
        });
        if (inventory.firstEmpty() == -1 || inventory.getItem(20) != null && page < 999) {
            inventory.setItem(53, next);
            inventory.setItem(52, next);
            inventory.setItem(51, next);
        }
        return inventory;
    }

    public static Inventory createGUI(SkinsRestorer plugin, int page) {
        if (page > 999) {
            page = 999;
        }
        int skinNumber = 36 * page;
        Map<String, IProperty> skinsList = plugin.getSkinStorage().getSkins(skinNumber);
        return SkinsGUI.createGUI(plugin, page, skinsList);
    }

    private static ItemStack createSkull(SRLogger log, String name, IProperty property) {
        ItemStack is = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta sm = (SkullMeta)Objects.requireNonNull(is).getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(C.c(Locale.SKINSMENU_SELECT_SKIN));
        Objects.requireNonNull(sm).setDisplayName(name);
        sm.setLore(lore);
        is.setItemMeta((ItemMeta)sm);
        try {
            BukkitHeadAPI.setSkull(is, property);
        }
        catch (Exception e) {
            log.info("ERROR: could not add '" + name + "' to SkinsGUI, skin might be corrupted or invalid!");
            e.printStackTrace();
        }
        return is;
    }

    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player) || event.getCurrentItem() == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack currentItem = event.getCurrentItem();
        if (!currentItem.hasItemMeta()) {
            return;
        }
        if (this.plugin.isProxyMode()) {
            switch (Objects.requireNonNull(XMaterial.matchXMaterial(currentItem))) {
                case PLAYER_HEAD: {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        String skin = Objects.requireNonNull(currentItem.getItemMeta()).getDisplayName();
                        this.plugin.requestSkinSetFromBungeeCord(player, skin);
                    });
                    player.closeInventory();
                    break;
                }
                case RED_STAINED_GLASS_PANE: {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.requestSkinClearFromBungeeCord(player));
                    player.closeInventory();
                    break;
                }
                case GREEN_STAINED_GLASS_PANE: {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.requestSkinsFromBungeeCord(player, this.page + 1));
                    break;
                }
                case YELLOW_STAINED_GLASS_PANE: {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.requestSkinsFromBungeeCord(player, this.page - 1));
                    break;
                }
            }
        } else {
            switch (Objects.requireNonNull(XMaterial.matchXMaterial(currentItem))) {
                case PLAYER_HEAD: {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        String skinName = Objects.requireNonNull(currentItem.getItemMeta()).getDisplayName();
                        this.plugin.getSkinCommand().onSkinSetShort(player, skinName);
                    });
                    player.closeInventory();
                    break;
                }
                case RED_STAINED_GLASS_PANE: {
                    this.plugin.getSkinCommand().onSkinClear(player);
                    player.closeInventory();
                    break;
                }
                case GREEN_STAINED_GLASS_PANE: {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        Inventory newInventory = SkinsGUI.createGUI(this.plugin, this.page + 1);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(newInventory));
                    });
                    break;
                }
                case YELLOW_STAINED_GLASS_PANE: {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        Inventory newInventory = SkinsGUI.createGUI(this.plugin, this.page - 1);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(newInventory));
                    });
                    break;
                }
            }
        }
    }

    public SkinsGUI(SkinsRestorer plugin, int page) {
        this.plugin = plugin;
        this.page = page;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public static class GuiGlass {
        private ItemStack itemStack;
        private String text;

        public GuiGlass(GlassType glassType) {
            switch (glassType) {
                case NONE: {
                    this.itemStack = XMaterial.WHITE_STAINED_GLASS_PANE.parseItem();
                    this.text = " ";
                    break;
                }
                case PREV: {
                    this.itemStack = XMaterial.YELLOW_STAINED_GLASS_PANE.parseItem();
                    this.text = C.c(Locale.SKINSMENU_PREVIOUS_PAGE);
                    break;
                }
                case NEXT: {
                    this.itemStack = XMaterial.GREEN_STAINED_GLASS_PANE.parseItem();
                    this.text = C.c(Locale.SKINSMENU_NEXT_PAGE);
                    break;
                }
                case DELETE: {
                    this.itemStack = XMaterial.RED_STAINED_GLASS_PANE.parseItem();
                    this.text = C.c(Locale.SKINSMENU_CLEAR_SKIN);
                }
            }
            ItemMeta itemMeta = Objects.requireNonNull(this.itemStack).getItemMeta();
            Objects.requireNonNull(itemMeta).setDisplayName(this.text);
            this.itemStack.setItemMeta(itemMeta);
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public String getText() {
            return this.text;
        }
    }

    private static enum GlassType {
        NONE,
        PREV,
        NEXT,
        DELETE;

    }
}

